package test.converter;

import java.util.Date;

import net.w_horse.excelpojo.annotation.Bean;
import net.w_horse.excelpojo.annotation.Converter;
import net.w_horse.excelpojo.annotation.PointedCell;

@Bean
public class AnnotationConverterPriority {
	@Converter(converterClass="net.w_horse.excelpojo.converter.StringDateConverter",
		properties="cellFormat = yyyy-MM-dd, fieldType=java.util.Date")
	private Date date1;

	@PointedCell(position="(2, 4)")
	@Converter(converterClass="net.w_horse.excelpojo.converter.StringDateConverter",
		properties="cellFormat = yyyy-MM-dd, fieldFormat= yyyy/MM/dd")
	private String dateStr1;

	@PointedCell(position="(3, 4)")
	@Converter(converterClass="net.w_horse.excelpojo.converter.StringBooleanConverter")
	private String dateStr2;

	public void setDate1(Date date1) {
		this.date1 = date1;
	}
	public Date getDate1() {
		return date1;
	}
	/**
	 * dateStr1擾܂B
	 * @return dateStr1
	 */
	public String getDateStr1() {
	    return dateStr1;
	}
	/**
	 * dateStr1ݒ肵܂B
	 * @param dateStr1 dateStr1
	 */
	public void setDateStr1(String dateStr1) {
	    this.dateStr1 = dateStr1;
	}
	/**
	 * dateStr2擾܂B
	 * @return dateStr2
	 */
	public String getDateStr2() {
	    return dateStr2;
	}
	/**
	 * dateStr2ݒ肵܂B
	 * @param dateStr2 dateStr2
	 */
	public void setDateStr2(String dateStr2) {
	    this.dateStr2 = dateStr2;
	}
}
